//Lab 6 :  Examine the steady state errors for Type 2 system.
//------------------------------------------------------------------
//Problem Statement: Examine the steady state errors in step,
//ramp and parabolic response of Type 2 system G=(s+0.5)/s^2/(s+0.8)
//------------------------------------------------------------------

//------------------------------------------------------------------
// Operating System OSX (Mac) 10.14.6
// Scilab Version 6.1.0
//------------------------------------------------------------------
xdel(winsid()) // close the figure windows
clear; // clear the workspace
clc; // clear the console
//------------------------------------------------------------------
// system representation

s=%s  //Laplace operator

//Type 1 system G=(s+0.5)/s^2/(s+0.8)

G=syslin('c',(s+0.5)/s^2/(s+0.8))
Gcl=G/(1+G) //closed loop Gcl=(s+0.5)/(s^3+0.8s^2+s+0.5)

//------------------------------------------------------

t=0:0.2:10             // Simulation time
dim=size(t);

u1=ones(dim(1),dim(2)) // unit step input
u2=t                   // unit ramp;
u3=t^2/2               // unit parabolic input 

// Unit step response

c1=csim(u1,t,Gcl)  // unit step response of closed loop system
c2=csim(u2,t,Gcl)  // unit rmp response of closed loop system
c3=csim(u3,t,Gcl)  // unit parabolic response closed loop system

plot(t,c1,t,c2,t,c3,t,'LineWidth',2)
plot(t,u1,'--',t,u2,'--',t,u3,'--','LineWidth',1.5)

xgrid

//Title, labels and grid to the figure
legend('unit step response','unit ramp response', 'unit parabolic response',2)
title('Responses of Type 2 system (dashed lines are inputs)' ,'fontsize',2)
xlabel('Time t (sec.)','fontsize',2)
ylabel('c(t)','fontsize',2)
